unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TRownanieKwadratowe = class
  strict private
    Fa,Fb,Fc :Double;
    function Delta :Double;
    procedure SetA(a :double);
    function GetX1 :Double;
    function GetX2 :Double;
  public
    constructor Create(a,b,c :Double);
    property a :Double read Fa write SetA;
    property b :Double read Fb write Fb;
    property c :Double read Fc write Fc;
    property X1 :Double read GetX1;
    property X2 :Double read GetX2;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TRownanieKwadratowe.SetA(a :double);
begin
if a<>0
  then Fa:=a
  else raise Exception.Create('Wspolczynnik a nie moze byc rowny zero!');
end;

constructor TRownanieKwadratowe.Create(a,b,c :Double);
begin
inherited Create;
Self.a:=a;
Self.b:=b;
Self.c:=c;
end;

function TRownanieKwadratowe.Delta :Double;
begin
Result:=b*b-4*a*c;
end;

function TRownanieKwadratowe.GetX1 :Double;
begin
if Delta<0 then raise Exception.Create('Rwnanie nie ma rozwiza');
Result:=(-b-Sqrt(Delta))/(2*a);
end;

function TRownanieKwadratowe.GetX2 :Double;
begin
if Delta<0 then raise Exception.Create('Rwnanie nie ma rozwiza');
Result:=(-b+Sqrt(Delta))/(2*a);
end;

procedure TForm1.Button1Click(Sender: TObject);
var rk :TRownanieKwadratowe;
begin
rk:=TRownanieKwadratowe.Create(1,1,-2);
try
  rk.a:=1;
  rk.b:=0;
  rk.c:=-1;
  ShowMessage('Rozwizania: x1='+FloatToStr(rk.X1)+', x2='+FloatToStr(rk.X2));
except
  on E: Exception do ShowMessage('Bd: '+E.Message);
end;
rk.Free;
end;

end.
